require( "quest/mg_bead/convout.lua" );
require( "quest/activity_mode/activity_common.lua" );
combine_speech_tables();

round_num = 
{
	4, -- round one
	4, -- round two
	ACTIVITY_LEVEL_MAX, -- activity mode -- quest/activity_mode/activity_timer.lua
};

function get_activity_bonus_time(level)
	return MINUTES(3) + SECONDS(30) + SECONDS(2)*level*level;
end

initial_setup = true;
initial_tutorial = false;
bead_tutorial_step = 0;
show_activity_text = false;
debug_show_bead_order = false;
going_back = false;

local flyInfo = { };

-- should have enough nodes for the longest pattern, even if some are off the screen
-- max number of beads is currently 63
local pathNodes = 
{
	-- Note: next bead to be sewn is placed at the position specified here as index 1
	{ x = 80, y = 270 }; { x = 81, y = 235 }; { x = 82, y = 200 }; { x = 83, y = 165 }; { x = 84, y = 130 }; { x = 85, y = 95 }; { x = 86, y = 60 }; 
	{ x = 130, y = 57 }; { x = 163, y = 57 }; { x = 199, y = 57 }; { x = 232, y = 57 }; { x = 265, y = 57 }; { x = 298, y = 57 }; { x = 331, y = 57 };
	{ x = 364, y = 57 }; { x = 397, y = 57 }; { x = 430, y = 57 }; { x = 463, y = 57 }; { x = 496, y = 57 }; { x = 531, y = 57 }; { x = 564, y = 57 };
	{ x = 597, y = 57 }; { x = 630, y = 57 }; { x = 663, y = 57 }; { x = 686, y = 35 }; { x = 667, y = 10 }; { x = 635, y = 10 }; { x = 602, y = 10 };
	{ x = 569, y = 10 }; { x = 536, y = 10 }; { x = 503, y = 10 }; { x = 470, y = 10 }; { x = 437, y = 10 }; { x = 404, y = 10 }; { x = 371, y = 10 };
	{ x = 338, y = 10 }; { x = 305, y = 10 }; { x = 272, y = 10 }; { x = 239, y = 10 }; { x = 206, y = 10 }; { x = 173, y = 10 }; { x = 140, y = 10 };
	{ x = 107, y = 10 }; { x = 74, y = 10 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 };
	{ x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 };
	{ x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 }; { x = 74, y = -41 };
};

local beadFormatInfo = 
{
	width_of_bead = 50,
	height_of_bead = 50,
	horizontal_space_between_beads = 65,
	vertical_space_between_beads = 25,
	bead_radius = 22,
};

local patternFormatInfo = 
{
	max_pattern_width = 7,
	min_pattern_width = 6,	
	max_pattern_height = 9,
	bead_horizontal_offset = ( beadFormatInfo["width_of_bead"] + beadFormatInfo["horizontal_space_between_beads"] ) / 2,
	bead_vertical_offset = ( beadFormatInfo["height_of_bead"] + beadFormatInfo["vertical_space_between_beads"] ) / 2,
	screen_x_offset = 160,
	screen_y_offset = 95
};

local strandFormatInfo = 
{
	screen_x_offset = 0,
	screen_y_offset = 0,
	bead_horizontal_offset = ( beadFormatInfo["width_of_bead"] + beadFormatInfo["horizontal_space_between_beads"] ) / 2
};
	
local numLoadedBeadsInPattern = 0;

local currentPattern = { };
local currentStrand = { };
local currentSolution = { };
local links = { };

local activityComplete = false;
local beadFlashing = false;

-- The idea is that a pattern table stores the colours of the beads, which is used as the key to index the beads table, which stores the info like image, etc.
local beads =
{
	-- sewn should be the same as the image of the bead on the strand, it is the image when the bead has been sewn in place on the pattern
	pink = { image = "pinkBead", highlight = "pinkBeadHighlight", sewn = "pinkBeadSewn", sewnHighlight = "pinkBeadHighlight2"};
	yellow = { image = "yellowBead", highlight = "yellowBeadHighlight", sewn = "yellowBeadSewn", sewnHighlight = "yellowBeadHighlight2" };
	green = { image = "greenBead", highlight = "greenBeadHighlight", sewn = "greenBeadSewn", sewnHighlight = "greenBeadHighlight2" };
	blue = { image = "blueBead", highlight = "blueBeadHighlight", sewn = "blueBeadSewn", sewnHighlight = "blueBeadHighlight2" };
	purple = { image = "purpleBead", highlight = "purpleBeadHighlight", sewn = "purpleBeadSewn", sewnHighlight = "purpleBeadHighlight2" };
	orange = { image = "orangeBead", highlight = "orangeBeadHighlight", sewn = "orangeBeadSewn", sewnHighlight = "orangeBeadHighlight2" };
	red =  { image = "redbead", highlight = "redbeadhighlight", sewn = "redbeadsewn", sewnHighlight = "redbeadhighlight2" };
	none = { image = "", highlight = "", sewn = "", sewnHighlight = "" };
};

local linkTypes = 
{
	horizontal = { image = "horizontalLink" };
	topLeftToBottomRight = { image = "tlbrLink" };
	topRightToBottomLeft = { image = "trblLink" };
};

-- these determine the order in which the beads must be sewn, index 1 is the first bead to be sewn
local strands = 
{
	-- round 1
	{
		--activity 1
		{
			length = 19;
			beads = 
				{ 
					"pink", "pink", "blue", "green", "pink", "pink", "blue", 
					"yellow", "blue", "pink", "pink", "green", "pink", "blue", 
					"pink", "yellow", "blue", "pink", "blue"
				};
			solution =
				{
					{
						45, 37, 31, 30, 23, 17, 24, 18, 25, 19, 26, 34, 40, 39, 47, 46, 38, 32, 33
					},
				}
		};
		
		--activity 2
		{
			length = 25;
			beads = 
				{ 
					"orange", "green", "purple", "purple", "green", "green", "green", "purple", "purple", 
					"orange", "orange", "orange", "green", "purple", "purple", "green", "orange", "orange", 
					"green", "purple", "purple", "green", "green", "orange", "orange"
				};
			solution =
				{
					{
						16, 23, 17, 24, 32, 33, 26, 25, 19, 20, 27, 34, 40, 48, 54, 47, 39, 38, 45, 51, 44, 37, 31, 30, 22
					},
				}
		};
		
		--[[
		--activity 2 alt
		{
			length = 31;
			beads = 
				{ 
					"blue", "pink", "pink", "pink", "green", "pink", "purple", "blue", 
					"yellow", "blue", "blue", "blue", "blue", "blue", "yellow", "blue", 
					"yellow", "blue", "blue", "blue", "blue", "blue", "blue", "pink", 
					"pink", "pink", "green", "pink", "pink", "pink", "pink"
				};
			solution = 
				{
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						41, 40,
						34, 26, 20, 12, 19, 25, 18, 11, 10
					},
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						41, 40,
						34, 26, 20, 12, 19, 25, 18, 10, 11
					},
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						41, 40,
						34, 26, 20, 12, 19, 11, 10, 18, 25
					},					
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						41, 40,
						34, 26, 25, 18, 19, 20, 12, 11, 10
					},
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						40, 41,
						34, 26, 20, 12, 19, 25, 18, 11, 10
					},
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						40, 41,
						34, 26, 20, 12, 19, 25, 18, 10, 11
					},
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						40, 41,
						34, 26, 20, 12, 19, 11, 10, 18, 25
					},					
					{
						30, 23, 16, 9, 17, 24, 32, 38, 45, 37, 36, 44, 51, 52, 46, 39, 47, 53, 54, 48,
						40, 41,
						34, 26, 25, 18, 19, 20, 12, 11, 10
					},
				};
		};
		
		--]]

		--activity 3
		{
			length = 31;
			beads = 
				{ 
					"purple", "purple", "purple", "pink", "pink", "green", "pink", "green", 
					"green", "green", "purple", "blue", "blue", "green", "blue", "green", 
					"pink", "purple", "pink", "pink", "green", "purple", "green", "green", "blue",
					"blue", "purple", "blue", "purple", "purple", "purple"
				};
			solution = 
				{
					{
						4, 11, 10, 17, 24, 31, 23, 22, 29, 36, 30, 37, 38, 32, 39, 33, 25, 18, 19, 26, 27, 34, 35, 41, 40, 47, 46, 45, 52, 53, 60
					},
					{
						4, 11, 10, 17, 24, 31, 23, 22, 29, 36, 30, 37, 38, 32, 39, 33, 25, 18, 19, 26, 27, 34, 35, 41, 40, 47, 46, 45, 52, 60, 53
					},
					{
						4, 10, 11, 19, 25, 33, 26, 27, 35, 41, 34, 40, 39, 32, 38, 31, 24, 18, 17, 23, 22, 30, 29, 36, 37, 45, 46, 47, 53, 52, 60
					},
					{
						4, 10, 11, 19, 25, 33, 26, 27, 35, 41, 34, 40, 39, 32, 38, 31, 24, 18, 17, 23, 22, 30, 29, 36, 37, 45, 46, 47, 53, 60, 52
					},
				};
		};

		--activity 4
		{
			length = 38;
			beads = 
				{ 
					"red", "red", "blue", "red", "red", "pink", "pink", "pink", "red", "red", 
					"red", "blue", "red", "red", "red", "red", "pink", "pink", "pink", "red", 
					"blue", "red", "red", "red", "pink", "pink", "red", "blue", "red", "pink", 
					"pink", "red", "blue", "pink", "red", "blue", "red", "pink"
				};
			solution = 
				{					
					{
						2, 3, 9, 8, 16, 15, 22, 23,
						24, 17, 10, 18, 11, 5, 6, 13, 21, 27, 26, 20, 12, 19, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46, 
						45, 52, 60, 53, 47
					},
					{
						2, 3, 9, 8, 16, 15, 22, 23,
						24, 17, 10, 18, 11, 5, 6, 13, 21, 27, 26, 20, 12, 19, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46, 
						47, 53, 60, 52, 45
					},
					{
						2, 3, 9, 16, 8, 15, 22, 23,
						24, 17, 10, 18, 11, 5, 6, 13, 21, 27, 26, 20, 12, 19, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46, 
						45, 52, 60, 53, 47
					},
					{
						2, 3, 9, 16, 8, 15, 22, 23,
						24, 17, 10, 18, 11, 5, 6, 13, 21, 27, 26, 20, 12, 19, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46, 
						47, 53, 60, 52, 45
					},
					{
						2, 3, 9, 8, 16, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 24, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46,
						47, 53, 60, 52, 45
					},
					{
						2, 3, 9, 8, 16, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 24, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46,
						45, 52, 60, 53, 47
					},	
					{
						2, 3, 9, 8, 16, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 25, 24, 31, 30, 37, 38, 32, 33, 34, 40, 39, 46,
						47, 53, 60, 52, 45
					},	
					{
						2, 3, 9, 8, 16, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 25, 24, 31, 30, 37, 38, 32, 33, 34, 40, 39, 46,
						45, 52, 60, 53, 47
					},						

					{
						2, 3, 9, 16, 8, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 24, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46,
						47, 53, 60, 52, 45
					},					
					{
						2, 3, 9, 16, 8, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 24, 25, 33, 34, 40, 39, 32, 31, 30, 37, 38, 46,
						45, 52, 60, 53, 47
					},							
					{
						2, 3, 9, 16, 8, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 25, 24, 31, 30, 37, 38, 32, 33, 34, 40, 39, 46,
						47, 53, 60, 52, 45
					},	
					{
						2, 3, 9, 16, 8, 15, 22, 23,
						17, 10, 11, 12, 5, 6, 13, 20, 21, 27, 26, 19, 18, 25, 24, 31, 30, 37, 38, 32, 33, 34, 40, 39, 46,
						45, 52, 60, 53, 47
					},	
				};
		};
	};
	-- round 2
	{
		--activity 1
		{
			length = 44;
			beads = 
				{ 
					"pink", "yellow", "blue", "purple", "yellow", "green", "purple", "purple", "pink", "purple",
					"purple", "green", "purple", "green", "purple", "blue", "pink", "purple", "purple", "pink",
					"pink", "blue", "purple", "green", "yellow", "pink", "yellow", "green", "purple", "purple",
					"green", "purple", "purple", "blue", "yellow", "pink", "yellow", "purple", "green", "purple",
					"green", "yellow", "pink", "yellow"
				};
			solution = 
				{
					{
						50, 51, 45, 37, 44, 36, 30, 31, 38, 46, 52, 59, 60, 61, 53, 47, 39, 40, 33, 25, 24, 17, 23, 22, 16, 8, 9, 3, 10, 4, 5, 11, 18, 19,
						12, 13, 20, 26, 27, 34, 41, 48, 55, 54
					},
				};
		};
		
		--[[
		--activity 1 alt
		{
			length = 36;
			beads = 
				{ 
					"yellow", "blue", "purple", "green", "yellow", "pink", "yellow", "purple", "yellow",
					"yellow", "green", "pink", "blue", "blue", "green", "purple", "pink", "purple",
					"pink", "green", "pink", "green", "blue", "purple", "yellow", "blue", "blue", 
					"green", "green", "pink", "purple", "blue", "blue", "yellow", "yellow", "blue"
				};
			solution = 
				{
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 22, 23, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 47, 54, 48, 40, 41, 34, 26, 33, 
						39, 38, 31
					},
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 22, 23, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 47, 54, 40, 48, 41, 34, 26, 33, 
						39, 38, 31
					},
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 23, 22, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 47, 54, 48, 40, 41, 34, 26, 33, 
						39, 38, 31
					},
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 23, 22, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 47, 54, 40, 48, 41, 34, 26, 33, 
						39, 38, 31
					},					
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 22, 23, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 54, 57, 48, 40, 41, 34, 26, 33, 
						39, 38, 31
					},
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 22, 23, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 54, 57, 40, 48, 41, 34, 26, 33, 
						39, 38, 31
					},
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 23, 22, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 54, 47, 48, 40, 41, 34, 26, 33, 
						39, 38, 31
					},
					{
						4, 3, 10, 11, 18, 19, 25, 32, 24, 17, 9, 16, 23, 22, 30, 29, 36, 43, 50, 51, 44, 37, 45, 46, 53, 54, 47, 40, 48, 41, 34, 26, 33, 
						39, 38, 31
					},					
				};
		};
		--]]

		--activity 2
		{
			length = 43;
			beads = 
				{ 
					"blue", "green", "purple", "green", "yellow", "purple", "pink", "yellow", "blue", "yellow",
					"pink", "purple", "yellow", "yellow", "pink", "yellow", "blue", "yellow", "green", "yellow",
					"yellow", "pink", "yellow", "green", "pink", "yellow", "purple", "pink", "blue", "pink",
					"purple", "yellow", "yellow", "pink", "yellow", "yellow", "green", "green", "green", "blue",
					"yellow", "yellow", "pink"
				};
			solution = 
				{
					{
						32, 25, 18, 24, 17, 9, 3, 10, 4, 11, 5, 12, 19, 26, 20, 27, 35, 41, 34, 33, 40, 48, 47, 39, 46, 53, 54, 61, 60, 59, 51, 52, 45,
						44, 36, 37, 38, 31, 30, 29, 22, 23, 16
					},
				};
		};

		--activity 3
		{
			length = 36;
			beads = 
				{ 
					"purple", "green", "green", "green", "green", "green", "green", "green", "yellow",
					"green", "green", "green", "green", "yellow", "green", "green", "green", "blue",
					"green", "purple", "pink", "green", "green", "green", "green", "pink", "green", 
					"green", "green", "green", "blue", "green", "green", "green", "green", "yellow"
				};
			solution =
				{
					{
						32, 33, 26, 25, 19, 11, 10, 17, 18, 24, 23, 22, 29, 30, 36, 37, 31, 38, 45, 46, 52, 51, 58, 59, 60, 53, 61, 62, 54, 47, 39, 
						40, 41, 35, 27, 34
					},
					{
						32, 33, 25, 26, 19, 11, 10, 17, 18, 24, 23, 22, 29, 30, 36, 37, 31, 38, 45, 46, 52, 51, 58, 59, 60, 53, 61, 62, 54, 47, 39, 
						40, 41, 35, 27, 34
					},					
					{
						32, 25, 33, 26, 19, 11, 10, 17, 18, 24, 23, 22, 29, 30, 36, 37, 31, 38, 45, 46, 52, 51, 58, 59, 60, 53, 61, 62, 54, 47, 39, 
						40, 41, 35, 27, 34
					},					
					{
						32, 31, 24, 23, 17, 10, 11, 19, 18, 25, 26, 27, 35, 34, 41, 40, 33, 39, 47, 46, 53, 54, 62, 61, 60, 52, 59, 58, 51, 45, 38, 37,
						36, 29, 22, 30
					},
					{
						32, 31, 23, 24, 17, 10, 11, 19, 18, 25, 26, 27, 35, 34, 41, 40, 33, 39, 47, 46, 53, 54, 62, 61, 60, 52, 59, 58, 51, 45, 38, 37,
						36, 29, 22, 30
					},
					{
						32, 24, 31, 23, 17, 10, 11, 19, 18, 25, 26, 27, 35, 34, 41, 40, 33, 39, 47, 46, 53, 54, 62, 61, 60, 52, 59, 58, 51, 45, 38, 37,
						36, 29, 22, 30
					},
				};
		};

		--activity 4
		{
			length = 40;
			beads = 
				{ 
					"green", "yellow", "yellow", "yellow", "green", "yellow", "purple", "yellow", "blue", "blue",					
					"blue", "blue", "yellow", "yellow", "yellow", "green", "yellow", "purple", "blue", "blue",
					"yellow", "yellow", "yellow", "yellow", "yellow", "green", "yellow", "yellow", "yellow", "yellow",
					"yellow", "yellow", "green", "yellow", "yellow", "yellow", "purple", "purple", "yellow", "yellow"
				};
			solution =
				{
					{
						4, 11, 19, 20, 21, 27, 26, 34, 33, 32, 25, 18, 10, 17, 16, 15, 22, 23, 24, 31, 30, 37, 45, 44, 50, 57, 58, 51, 52, 53, 54, 
						62, 63, 55, 48, 40, 39, 38, 46, 47
					},
					
					{
						4, 10, 17, 16, 15, 22, 23, 30, 31, 32, 24, 18, 11, 19, 20, 21, 27, 26, 25, 33, 34, 40, 47, 48, 55, 63, 62, 54, 53, 52, 51,
						58, 57, 50, 44, 37, 38, 39, 46, 45
					},
				};
		};
	};
	
	-- activity mode
	{
		--activity 1
		{
			length = 23;
			beads = 
				{ 
					"pink", "orange", "green", "pink", "purple", "purple", "orange",
					"pink", "orange", "green", "pink", "orange", "purple", "purple",
					"green", "pink", "purple", "pink", "green", "purple", "purple",
					"orange", "orange"

				};
			solution =
				{
					{
						44, 45, 38, 46, 52, 53, 47, 48, 40, 39, 32, 33, 25, 26, 19, 11, 18, 10, 17, 24, 23, 31, 37
					},
				}
		};
		
		--activity 2
		{
			length = 33;
			beads = 
				{ 
					"green", "green", "green", "red", "pink", "blue", "green", "green", "blue", "green", 
					"green", "red", "pink", "green", "blue", "yellow", "red", "red", "red", "green", "green", 
					"green", "green", "blue", "green", "pink", "green", "pink", "yellow", "red", "red", "red", "green" 
				};
			solution =
				{
					{
						
					},

				};
		};



		--activity 3
		{
			length = 26;
			beads = 
				{ 
					"green", "blue", "yellow", "yellow", "blue", "green", "green", "yellow",
					"blue", "green", "yellow", "yellow", "blue", "yellow", "blue", "green",
					"green", "green", "yellow", "blue", "green", "blue", "yellow", "yellow",
					"green", "blue"
				};
			solution =
				{
					{
						44, 45, 38, 31, 37, 36, 30, 22, 23, 24, 32, 33, 40, 39, 47, 48,
						41, 34, 27, 26, 25, 19, 11, 10, 18, 17
					},
				}
		};


		--activity 4
		{
			length = 28;
			beads = 
				{ 
					"red", "red", "yellow", "blue", "green", "red", "red", "red", "blue", "yellow",
					"yellow", "blue", "yellow", "yellow", "red", "red", "red", "blue", "blue",
					"green", "red", "red", "red", "blue", "yellow", "blue", "blue", "red"
				};
			solution = 
				{
					{
						8, 16, 17, 23, 22, 30, 36, 37, 31, 24, 25, 32, 38, 39, 40, 41,
						34, 33, 26, 27, 20, 13, 12, 11, 19, 18, 10, 9
					},
					
				};
		};

		--activity 5
		{
			length = 30;
			beads = 
				{ 
					"red", "pink", "red", "purple", "pink", "red", "pink", "red", "purple", "pink",
					"red", "pink", "red", "pink", "purple", "red", "purple", "red", "red", "purple",
					"red", "purple", "purple", "pink", "pink", "pink", "red", "purple", "red", "red"
				};
			solution = 
				{
					{
						50, 51, 52, 45, 44, 37, 31, 38, 46, 53, 54, 47, 39, 32, 25, 24, 23, 22,
						16, 8, 9, 17, 18, 10, 3, 4, 11, 12, 19, 26
					},
					
				};
		};



--[[
		--activity 5 alt
		{
			length = 34;
			beads = 
				{ 
					"blue", "pink", "pink", "orange", "yellow", "pink", "orange", "yellow", "blue", "pink",
					"blue", "orange", "pink", "pink", "blue", "orange", "yellow", "pink", "orange", "pink",
					"yellow", "blue", "orange", "pink", "yellow", "pink", "orange", "blue",
					"pink", "pink", "orange", "yellow", "pink", "pink"
				};
			solution = 
				{
					{
						2, 8, 16, 17, 23, 31, 38, 37, 30, 36, 44, 45, 52, 53, 47, 39, 32, 33, 40,
						48, 41, 34, 26, 25, 24, 18, 19, 20, 13, 6, 5, 11, 10, 3
					},

				};
		};

]]--		

		--activity 6
		{
			length = 34;
			beads = 
				{ 
					"red", "yellow", "yellow", "purple", "purple", "red", "yellow", "yellow", "purple", 
					"purple", "purple", "red", "purple", "purple", "red", "purple", "yellow", "yellow",
					"yellow", "yellow", "red", "yellow", "yellow", "purple", "purple", "purple", "red",
					"yellow", "yellow", "red", "purple", "purple", "yellow", "purple"
				};
			solution = 
				{
					{
						
					},
				};
		};



		--activity 7
		{
			length = 43;
			beads = 
				{ 
					"purple", "green", "green", "green", "purple", "orange", "purple", "orange", "purple", "purple", 
					"orange", "purple", "green", "green", "orange", "green", "green", "green", "purple", "purple", "green",
					"green", "purple", "orange", "purple", "green", "green", "purple", "orange", "purple", "purple", "purple",
					"green", "purple", "purple", "green", "purple", "purple", "purple", "orange", "purple", "green", "green"
				};
			solution =
				{
					{
						
					},
				}
		};

		--activity 8
		{
			length = 39;
			beads = 
				{ 
					"orange", "orange", "orange", "orange", "orange", "red", "orange", "orange", "orange", "orange", "orange", 
					"green", "orange", "blue", "orange", "orange", "red", "orange", "orange", "green", "orange", "orange", "orange", 
					"red", "red", "orange", "orange", "blue", "orange", "orange", "red", "orange", "orange", "orange", "orange", "orange", 
					"orange", "green", "green"
				};
			solution = 
				{
					{
						29, 22, 30, 36, 44, 37, 31, 23, 16, 9, 17, 10, 18, 24, 32, 38, 45, 51, 52, 60, 53, 54, 48,
						47, 46, 39, 33, 25, 26, 34, 41, 35, 27, 20, 12, 19, 11, 4
					},
				};
		};

		--activity 9
		{
			length = 40;
			beads = 
				{ 
					"red", "red", "red", "pink", "blue", "pink", "blue", "blue", "pink", "pink",
					"red", "red", "red", "red", "red", "red", "pink", "blue", "pink", "pink", "red", "blue",
					"pink", "blue", "yellow", "blue", "yellow", "yellow", "blue", "pink", "blue", "pink", 
					"blue", "pink", "red", "blue", "blue", "pink", "pink", "red"
				};
			solution =
				{
					{
						
					},
				}
		};
		

		
		--activity 10
		{
			length = 49;
			beads = 
				{ 
					"red", "pink", "pink", "pink", "blue", "pink", "pink", "pink", "orange", "pink", "pink", "pink", "pink",
					"blue", "pink", "pink", "red", "pink", "blue", "pink", "orange", "orange", "yellow", "orange", "pink", 
					"pink", "pink", "pink", "red", "pink", "blue", "pink", "red", "pink", "pink", "blue", "pink", "pink", 
					"orange", "pink", "orange", "blue", "pink", "pink", "red", "pink", "pink", "pink", "red"
				};
			solution = 
				{
					{
						1, 2, 8, 16, 17, 9, 10, 18, 24, 23, 30, 36, 37, 44, 43, 50, 57, 58, 51, 45,
						38, 31, 32, 39, 40, 47, 46, 52, 60, 53, 54, 62, 63, 55, 49, 48, 41, 34, 33,
						26, 25, 19, 20, 13, 7, 6, 12, 11, 4
					},
					
				};
		};

		--activity 11
		{
			length = 59;
			beads = 
				{ 
					"yellow", "blue", "blue", "pink", "pink", "yellow", "pink", "red", "red", "red", "blue", "blue",
					"green", "green", "pink", "pink", "yellow", "pink", "pink", "pink", "red", "yellow", "red", "red",
					"blue", "blue", "yellow", "blue", "pink", "pink", "pink", "red", "red", "blue", "red", "pink", "blue",
					"pink", "yellow", "pink", "pink", "red", "yellow", "red", "green", "blue", "blue", "yellow", "blue", 
					"blue", "blue", "green", "green", "green", "blue", "blue", "green", "blue", "green"
				};
			solution =
				{
					{
				
					},
					
				};
		};

		--activity 12
		{
			length = 33;
			beads = 
				{ 
					"red", "red", "red", "orange", "orange", "yellow", "yellow", "green", "green", "yellow", "orange", "yellow",
					"green", "blue", "purple", "blue", "purple", "purple", "purple", "purple", "purple", "blue", "blue",
					"green", "yellow", "green", "yellow", "orange", "red", "red", "red", "red", "orange"
				};
			solution = 
				{
					{
					},
					
				};
		};

		--activity 13
		{
			length = 43;
			beads = 
				{ 
					"purple", "blue", "purple", "blue", "blue", "green", "green", "blue", "green", "green", "purple",
					"blue", "green", "purple", "blue", "green", "green", "green", "yellow", "yellow", "red", "yellow",
					"red", "red", "yellow", "green", "blue", "green", "green", "blue", "purple", "blue", "blue", 
					"green", "green", "green", "yellow", "red", "red", "yellow", "yellow", "yellow", "red"
				};
			solution = 
				{
					{
						
					},
					
				};
		};

--[[
		--activity 13 alt
		{
			length = 49;
			beads = 
				{ 
					"blue", "green", "green", "blue", "blue", "yellow", "yellow", "blue", "yellow", "yellow", "blue", "blue", 
					"green", "green", "yellow", "green", "blue", "green", "blue", "green", "green", "green", "blue", "blue", 
					"blue", "yellow", "blue", "yellow", "yellow", "green", "green", "blue", "yellow", "green", "blue", "green",
					"green", "yellow", "green", "yellow", "blue", "blue", "yellow", "yellow", "blue", "blue", "blue", "blue", "green"
				};
			solution =
				{
					{
						
					},
					

				};
		};
		
]]--

		--activity 14
		{
			length = 49;
			beads = 
				{ 
					"blue", "green", "yellow", "yellow", "green", "green", "yellow", "yellow", "orange", "orange", "red",
					"orange", "red", "red", "red", "orange", "red", "orange", "yellow", "yellow", "orange", "red", "red",
					"red", "orange", "yellow", "green", "yellow", "green", "yellow", "orange", "orange", "yellow", "green",
					"green", "blue", "blue", "purple", "blue", "blue", "green", "green", "yellow", "orange", "orange",
					"orange", "red", "red", "red"
				};
			solution = 
				{
					{
					},
					
				};
		};


		
		--activity 15
		{
			length = 35;
			beads = 
				{ 
					"red", "orange", "yellow", "yellow", "orange", "yellow", "green", "green", "green", "yellow", "yellow",
					"green", "blue", "purple", "purple", "blue", "purple", "green", "yellow", "yellow", "green", "blue",
					"green", "yellow", "orange", "yellow", "orange", "red", "red", "red", "orange", "orange", "red", "red",
					"red", "red"
				};
			solution = 
				{
					{
						
					},
				};
		};
		


		--activity 16
		{
			length = 46;
			beads = 
				{ 
					"red", "pink", "red", "pink", "red", "pink", "orange", "red", "pink", "yellow", "orange", "yellow",
					"orange", "blue", "green", "purple", "purple", "blue", "purple", "green", "blue", "orange", "yellow",
					"pink", "red", "pink", "red", "pink", "red", "red", "pink", "orange", "yellow", "blue", "green", "yellow",
					"orange", "blue", "purple", "purple", "purple", "green", "blue", "yellow", "red", "pink"
				};
			solution =
				{
					{
						
					},
					
				};
		};


	};
};

local numBeadsSewn = 0;

-- where the first bead sewn has index 1
local sewnBeadHistory = { };

local firstBeadIndex = 0;

local numBeadsInPattern = 0;
local transitioning = false;

-- Note: since row lengths alternate, "none" should be used as padding at the END of every second row
-- Note: Don't need to specify trailing rows where no beads are present, but must specify entire row where any bead is present. All beads in all rows are specified below for clarity.
local patterns = 
{
	-- round 1
	{
		-- activity 1 
		{
			firstBeadIndex = 45;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "pink", "yellow", "pink", "none", "none" };
				{ "none",  "pink", "blue", "blue", "pink", "none", "none" };
				{ "none",  "green", "blue", "pink", "blue", "green", "none" };
				{ "none",  "pink", "blue", "blue", "pink", "none", "none" };
				{ "none",  "none", "pink", "yellow", "pink", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};
		-- activity 2
		{
			firstBeadIndex = 16;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "orange", "purple", "none", "purple", "orange", "none" };
				{ "orange", "green", "purple", "purple", "green", "orange", "none" };
				{ "none",  "orange", "green", "green", "green", "orange", "none" };
				{ "none",  "green", "orange", "orange", "green", "none", "none" };
				{ "none",  "purple", "green", "none", "green", "purple", "none" };
				{ "none",  "purple", "none", "none", "purple", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};
		
		--[[
		-- activity 2 alt
		{
			firstBeadIndex = 30;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "pink", "pink", "pink", "pink", "none", "none" };
				{ "none",  "pink", "green", "pink", "green", "pink", "none" };
				{ "none",  "pink", "pink", "pink", "pink", "none", "none" };
				{ "none",  "blue", "none", "purple", "none", "blue", "none" };
				{ "blue",  "blue", "blue", "blue", "blue", "blue", "none" };
				{ "none",  "blue", "yellow", "yellow", "yellow", "blue", "none" };				
				{ "none",  "blue", "blue", "blue", "blue", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};
		--]]
		-- activity 3
		{
			firstBeadIndex = 4;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "purple", "none", "none", "none" };
				{ "none",  "none", "purple", "purple", "none", "none", "none" };
				{ "none",  "none", "pink", "purple", "pink", "none", "none" };
				{ "green",  "pink", "pink", "pink", "pink", "green", "none" };
				{ "green",  "purple", "green", "green", "green", "purple", "green" };
				{ "green",  "blue", "blue", "blue", "blue", "green", "none" };
				{ "none",  "none", "blue", "purple", "blue", "none", "none" };				
				{ "none",  "none", "purple", "purple", "none", "none", "none" };
				{ "none",  "none", "none", "purple", "none", "none", "none" };
			};
		};
		-- activity 4
		{
			firstBeadIndex = 2;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "red", "red", "none", "red", "red", "none" };
				{ "red", "blue", "red", "red", "blue", "red", "none" };
				{ "pink",  "red", "red", "blue", "red", "red", "pink" };
				{ "pink",  "pink",  "red", "red", "pink",  "pink",  "none" };
				{ "none",  "pink",  "red", "blue", "red", "pink",  "none" };
				{ "none",  "pink",  "red", "red", "pink",  "none", "none" };
				{ "none",  "none", "pink",  "blue", "pink",  "none", "none" };
				{ "none",  "none", "red", "red", "none", "none", "none" };
				{ "none",  "none", "none", "blue", "none", "none", "none" };
			};
		};


	};
	-- round 2
	{
		-- activity 1 
		{
			firstBeadIndex = 50;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "green", "purple", "green", "none", "none" };
				{ "pink",  "yellow", "purple", "purple", "yellow", "pink", "none" };
				{ "none",  "yellow", "blue", "purple", "blue", "yellow", "none" };
				{ "green",  "purple", "pink", "pink", "purple", "green", "none" };
				{ "none",  "purple", "purple", "none", "purple", "purple", "none" };
				{ "green",  "purple", "pink", "pink", "purple", "green", "none" };
				{ "none",  "yellow", "blue", "purple", "blue", "yellow", "none" };
				{ "pink",  "yellow", "purple", "purple", "yellow", "pink", "none" };
				{ "none",  "none", "green", "purple", "green", "none", "none" };
			};
		};
		--[[
		-- activity 1 alt
		{
			firstBeadIndex = 4;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "blue", "yellow", "none", "none", "none" };
				{ "none",  "green", "purple", "green", "none", "none", "none" };
				{ "none",  "pink", "yellow", "yellow", "pink", "none", "none" };
				{ "blue",  "blue", "yellow", "yellow", "blue", "none", "none" };
				{ "purple", "green", "blue", "purple", "blue", "purple", "none" };
				{ "pink",  "green", "yellow", "yellow", "green", "pink", "none" };
				{ "purple",  "pink", "blue", "purple", "blue", "green", "none" };
				{ "pink",  "green", "none", "yellow", "blue", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};
		--]]
		-- activity 2
		{
			firstBeadIndex = 32;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "pink", "blue", "pink", "none", "none" };
				{ "none",  "purple", "yellow", "yellow", "purple", "none", "none" };
				{ "none",  "pink", "yellow", "purple", "yellow", "pink", "none" };
				{ "yellow",  "yellow", "green", "green", "yellow", "yellow", "none" };
				{ "blue",  "green", "green", "blue", "yellow", "green", "blue" };
				{ "yellow",  "yellow", "green", "green", "yellow", "yellow", "none" };
				{ "none",  "pink", "yellow", "pink", "yellow", "pink", "none" };
				{ "none",  "purple", "yellow", "yellow", "purple", "none", "none" };
				{ "none",  "none", "pink", "blue", "pink", "none", "none" };
			};
		};
		-- activity 3
		{
			firstBeadIndex = 32;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "green", "green", "none", "none", "none" };
				{ "none",  "none", "green", "yellow", "green", "none", "none" };
				{ "green",  "green", "green", "green", "green", "green", "none" };
				{ "green",  "yellow", "green", "purple", "green", "yellow", "green" };
				{ "green",  "green", "blue", "blue", "green", "green", "none" };
				{ "none",  "none", "green", "purple", "green", "none", "none" };
				{ "none",  "green", "pink", "pink", "green", "none", "none" };
				{ "none",  "green", "green", "green", "green", "green", "none" };
			};
		};
		-- activity 4
		{
			firstBeadIndex = 4;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "green", "none", "none", "none" };
				{ "none",  "none", "yellow", "yellow", "none", "none", "none" };
				{ "green",  "yellow", "yellow", "blue", "yellow", "yellow", "green" };
				{ "yellow",  "purple", "blue", "blue", "purple", "yellow", "none" };
				{ "none",  "yellow", "blue", "blue", "blue", "yellow", "none" };
				{ "none",  "yellow", "purple", "purple", "yellow", "none", "none" };
				{ "none",  "yellow", "yellow", "yellow", "yellow", "yellow", "none" };
				{ "yellow",  "yellow", "yellow", "yellow", "yellow", "yellow", "none" };
				{ "green",  "yellow", "none", "none", "none", "yellow", "green" };
			};
		};
	};
	
	-- activity mode
	{
		-- activity 1 
		{
			firstBeadIndex = 44;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "pink", "pink", "none", "none", "none" };
				{ "none",  "none", "green", "purple", "green", "none", "none" };
				{ "none",  "purple", "purple", "purple", "purple", "none", "none" };
				{ "none",  "none", "orange", "pink", "orange", "none", "none" };
				{ "none",  "orange", "green", "green", "orange", "none", "none" };
				{ "none",  "pink", "orange", "pink", "orange", "pink", "none" };
				{ "none",  "none", "purple", "purple", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};

		-- activity 2
		{
			firstBeadIndex = 29;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "red", "red", "none", "none", "none" };
				{ "none",  "green", "red", "yellow", "red", "green", "none" };
				{ "green", "pink", "blue", "pink", "blue", "green", "none" };
				{ "green", "green", "green", "green", "green", "green", "green", };
				{ "green", "blue", "pink", "blue", "pink", "green", "none" };
				{ "none",  "green", "red", "yellow", "red", "green", "none" };
				{ "none",  "none", "red", "red", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};


		-- activity 3
		{
			firstBeadIndex = 44;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none", "none", "yellow", "yellow", "none", "none","none" };
				{ "none", "none", "blue", "green", "blue", "none", "none" };
				{ "yellow", "blue", "green", "green", "blue", "yellow","none"  };
				{ "none", "green", "yellow", "yellow", "yellow", "green", "none" };
				{ "green", "blue", "yellow", "yellow", "blue", "green","none"  };
				{ "none", "green", "blue", "none", "blue", "green", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};


		-- activity 4
		{
			firstBeadIndex = 8;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "red",  "red", "blue", "blue", "red", "red", "none" };
				{ "none",  "red", "yellow", "blue", "yellow", "red", "none" };
				{ "green",  "blue", "yellow", "yellow", "blue", "green", "none" };
				{ "none",  "red", "blue", "blue", "blue", "red", "none" };
				{ "red",  "red", "yellow", "yellow", "red", "red", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};

		-- activity 5
		{
			firstBeadIndex = 50;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "pink", "pink", "none", "none", "none" };
				{ "purple",  "red", "pink", "red", "purple", "none", "none" };
				{ "none",  "red", "purple", "purple", "red", "none", "none" };
				{ "red",  "purple", "red", "purple", "red", "none", "none" };
				{ "none",  "none", "pink", "pink", "none", "none", "none" };
				{ "none",  "red", "red", "red", "none", "none", "none" };
				{ "none",  "pink", "purple", "purple", "pink", "none", "none" };
				{ "red",  "pink", "red", "pink", "red", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};

--[[

		-- activity 5 alt
		{
			firstBeadIndex = 2;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "blue", "pink", "none", "pink", "pink", "none" };
				{ "pink",  "none", "pink", "orange", "none", "blue", "none" };
				{ "none",  "pink", "orange", "yellow", "pink", "orange", "none" };
				{ "none",  "yellow", "pink", "orange", "yellow", "none", "none" };
				{ "none",  "blue", "pink", "yellow", "pink", "pink", "none" };
				{ "pink",  "yellow", "orange", "orange", "yellow", "orange", "none" };
				{ "none",  "blue", "orange", "none", "blue", "blue", "none" };
				{ "none",  "none", "pink", "pink", "none", "none", "none" };
				{ "none",  "none", "none", "none", "none", "none", "none" };
			};
		};
]]--

		-- activity 6
		{
			firstBeadIndex = 37;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "none", "none", "none", "none" };
				{ "yellow",  "yellow",  "yellow",  "yellow",  "yellow",  "yellow",  "none" };
				{ "none",  "purple", "red", "purple", "red", "purple", "none" };
				{ "none",  "purple", "purple", "purple", "purple", "none", "none" };
				{ "none",  "none", "purple", "red", "purple", "none", "none" };
				{ "none",  "red", "yellow", "yellow", "red", "none", "none" };
				{ "none",  "none", "yellow", "yellow", "yellow", "none", "none" };
				{ "none",  "yellow", "red", "red", "yellow", "none", "none" };
				{ "none",  "purple", "purple", "purple", "purple", "purple", "none" };
			};
		};


		-- activity 7
		{
			firstBeadIndex = 38;
			loadedBeads = 63;
			rows = 
			{
				{ "purple", "green", "purple", "purple", "green", "purple", "none" };
				{ "purple", "purple", "none", "purple", "purple", "none", "none"  };
				{ "green", "purple", "orange", "orange", "purple", "green", "none"  };
				{ "green", "purple", "orange", "purple", "green", "none", "none"  };
				{ "none", "green", "purple", "purple", "green", "none", "none"  };
				{ "none", "green", "purple", "green", "none", "none", "none"  };
				{ "none", "green", "green", "green", "green", "none", "none"  };
				{ "green", "orange", "purple", "orange", "green", "none", "none"  };
				{ "purple", "orange", "purple", "purple", "orange", "purple", "none"  };
			};
		};

		-- activity 8
		{
			firstBeadIndex = 29;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "none", "green", "none", "none", "none" };
				{ "none",  "orange", "green", "green", "orange", "none", "none" };
				{ "none",  "orange", "orange", "orange", "orange", "orange", "none" };
				{ "orange", "orange", "blue", "blue", "orange", "orange", "none" };
				{ "orange", "orange", "orange", "orange", "orange", "orange", "orange", };
				{ "orange", "red", "orange", "orange", "red", "orange", "none" };
				{ "none",  "orange", "red", "red", "red", "orange", "none" };
				{ "none",  "orange", "orange", "orange", "orange", "none", "none" };
				{ "none",  "none", "none", "green", "none", "none", "none" };
			};
		};

		-- activity 9
		{
			firstBeadIndex = 32;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "pink", "pink", "none", "pink", "pink", "none" };
				{ "blue",  "blue",  "red", "red", "blue",  "blue",  "none" };
				{ "none",  "pink", "red", "red", "red", "pink", "none" };
				{ "none",  "blue",  "red", "red", "blue",  "none", "none" };
				{ "none",  "pink", "red", "red", "red", "pink", "none" };
				{ "none",  "blue",  "red", "red", "blue",  "none", "none" };
				{ "none",  "pink", "pink", "pink", "pink", "pink", "none" };
				{ "none",  "blue",  "blue",  "blue",  "blue",  "none", "none" };
				{ "none",  "none", "yellow", "yellow", "yellow", "none", "none" };
			};
		};



		
		-- activity 10
		{
			firstBeadIndex = 1;
			loadedBeads = 63;
			rows = 
			{
				{ "red",  "pink", "none", "red", "none", "pink", "red" };
				{ "pink", "pink", "pink", "pink", "pink", "pink", "none" };
				{ "none",  "pink", "blue", "pink", "blue", "pink", "none" };
				{ "none",  "pink", "orange", "orange", "pink", "none", "none" };
				{ "none",  "pink", "orange", "yellow", "orange", "pink", "none" };
				{ "pink", "pink", "orange", "orange", "pink", "pink", "none" };
				{ "pink", "blue", "pink", "pink", "pink", "blue", "pink", };
				{ "pink", "blue", "pink", "pink", "blue", "pink", "none" };
				{ "red",  "pink", "none", "red", "none", "pink", "red" };
			};
		};

		-- activity 11
		{
			firstBeadIndex = 18;
			loadedBeads = 63;
			rows = 
			{
				{ "pink",  "pink",  "green", "green", "pink",  "yellow", "pink",  };
				{ "yellow", "pink",  "blue", "blue", "pink",  "pink",  "none" };
				{ "pink",  "pink",  "blue", "yellow", "blue", "red", "red" };
				{ "red", "red", "blue", "blue", "red", "yellow", "none" };
				{ "red", "yellow", "red", "pink",  "pink",  "red", "red", };
				{ "red", "red", "pink",  "yellow", "pink",  "green", "none" };
				{ "green",  "blue", "blue", "pink",  "pink",  "blue", "blue", };
				{ "blue", "yellow", "blue", "green", "blue", "yellow", "none" };
				{ "green", "blue", "blue", "green", "green", "blue", "blue", };
			};
		};

		-- activity 12
		{
			firstBeadIndex = 3;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "red", "red", "red", "none", "none" };
				{ "none",  "red", "red", "red", "red", "none", "none" };
				{ "none",  "orange", "orange", "orange", "orange", "orange", "none" };
				{ "yellow",  "yellow",  "yellow",  "yellow",  "yellow",  "yellow",  "none" };
				{ "none",  "green", "green", "green", "green", "green", "none" };
				{ "none",  "blue", "blue", "blue", "blue", "none", "none" };
				{ "none",  "none", "purple", "purple", "purple", "none", "none" };
				{ "none",  "none", "purple", "purple", "none", "none", "none" };
				{ "none",  "none", "none", "purple", "none", "none", "none" };
			};
		};

		-- activity 13
		{
			firstBeadIndex = 32;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "red", "yellow", "none", "none", "none", "none" };
				{ "red",  "red", "yellow", "green", "green", "none", "none" };
				{ "none",  "yellow", "yellow", "green", "blue", "blue", "none" };
				{ "green",  "green", "green", "purple", "purple", "blue", "none" };
				{ "green",  "blue", "blue", "purple", "blue", "blue", "green" };
				{ "blue",  "purple", "purple", "green", "green", "green", "none" };
				{ "none",  "blue", "blue", "green", "yellow", "yellow", "none" };
				{ "none",  "green", "green", "yellow", "red", "yellow", "none" };
				{ "none",  "none", "none", "none", "red", "red", "none" };
			};
		};
--[[
		-- activity 13 alt
		{
			firstBeadIndex = 58;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "yellow", "green", "blue", "green", "yellow", "none" };
				{ "blue", "green", "green", "green", "green", "blue", "none" };
				{ "none",  "blue", "yellow", "blue", "yellow", "blue", "none" };
				{ "yellow", "yellow", "yellow", "yellow", "yellow", "yellow", "none" };
				{ "none",  "blue", "yellow", "blue", "yellow", "blue", "none" };
				{ "blue", "blue", "blue", "blue", "blue", "blue", "none" };
				{ "none",  "blue", "green", "blue", "green", "blue", "none" };
				{ "green", "green", "green", "green", "green", "green", "none" };
				{ "none",  "blue", "green", "yellow", "green", "blue", "none" };
			};
		};

]]--
		-- activity 14
		{
			firstBeadIndex = 46;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "red", "red", "red", "none", "none" };
				{ "none",  "red", "orange", "orange", "red", "none", "none" };
				{ "none",  "red", "orange", "yellow", "orange", "red", "none" };
				{ "red", "orange", "yellow", "yellow", "orange", "red", "none" };
				{ "red",  "orange", "yellow", "green", "yellow", "orange", "red" };
				{ "orange", "yellow", "green", "green", "yellow", "orange", "none" };
				{ "orange", "yellow", "green", "blue", "green", "yellow", "orange", };
				{ "yellow", "green", "blue", "blue", "green", "yellow", "none" };
				{ "none",  "green", "blue", "purple", "blue", "green", "none" };
			};
		};

		
		-- activity 15
		{
			firstBeadIndex = 44;
			loadedBeads = 63;
			rows = 
			{
				{ "none",  "none", "purple", "purple", "purple", "none", "none" };
				{ "none",  "green", "blue", "blue", "green", "none", "none" };
				{ "none",  "yellow", "green", "blue", "green", "yellow", "none" };
				{ "none",  "yellow", "green", "green", "yellow", "none", "none" };
				{ "none",  "none", "yellow", "green", "yellow", "none", "none" };
				{ "none",  "orange", "yellow", "yellow", "orange", "none", "none" };
				{ "none",  "red", "orange", "yellow", "orange", "red", "none" };
				{ "none",  "red", "orange", "orange", "red", "none", "none" };
				{ "none",  "none", "red", "red", "red", "none", "none" };
			};
		};

		-- activity 16
		{
			firstBeadIndex = 62;
			loadedBeads = 63;
			rows = 
			{
				{ "pink",  "red", "orange", "blue", "purple", "none", "none" };
				{ "red", "pink",  "yellow", "green", "purple", "none", "none" };
				{ "none",  "pink",  "red", "orange", "blue", "purple", "none" };
				{ "yellow",  "red", "pink",  "yellow", "green", "none", "none" };
				{ "blue",  "orange", "pink", "red",  "orange", "blue", "none" };
				{ "green",  "yellow", "red", "pink",  "yellow", "none", "none" };
				{ "purple",  "blue", "orange", "pink", "red",  "none", "none" };
				{ "purple",  "green", "yellow", "red", "pink",  "none", "none" };
				{ "none", "purple",  "blue", "orange", "pink", "red", "none" };
			};
		};

	};
};

-- Expires all created objects. Could make a much better object manager, but this seems to work for now.
function reset()
	for i = 1, numLoadedBeadsInPattern do 	
		currentPattern[i].bead:Expire();
	end

	for i = 1, numBeadsInPattern do		
		currentStrand[i].bead:Expire();
	end

	for i = 1, numBeadsSewn - 1 do
		HideLink();
		numBeadsSewn = numBeadsSewn - 1;
	end

	currentPattern = { };
	currentStrand = { };
	links = { };
	numBeadsSewn = 0;
	local sewnBeadHistory = { };
	firstBeadIndex = 0;
	numBeadsInPattern = 0;
end

-- Every second row is a short row and some calculations need to account for this
function IsInShortRowOffset(index)
	if ( fmod( index, 2 * patternFormatInfo["max_pattern_width"] ) <= patternFormatInfo["max_pattern_width"] ) then
		return 0;
	end
	return 1;
end

-- check that neighbour does not wrap around
function IsLeftNeighbour(index1, index2)
	if ( ( fmod( index1, 7 ) ~= 1 ) and ( index1 == index2 + 1 ) ) then
		return true;
	end
	return false;
end

-- check that neighbour does not wrap around
function IsRightNeighbour(index1, index2)
	if ( ( fmod( index1, 7 ) ~= 0 ) and ( index1 == index2 - 1 ) ) then
		return true;
	end
	return false;
end

function IsUpperLeftNeighbour(index1, index2)
	if ( index1 == ( index2 - patternFormatInfo["max_pattern_width"] ) - IsInShortRowOffset(index1) ) then
		return true;
	end
	return false;
end

function IsUpperRightNeighbour(index1, index2)
	if ( index1 == ( ( index2 - patternFormatInfo["max_pattern_width"] ) + 1 ) - IsInShortRowOffset(index1) ) then
		return true;
	end
	return false;
end

function IsLowerLeftNeighbour(index1, index2)
	if ( index1 ==( ( index2 + patternFormatInfo["max_pattern_width"] ) ) - IsInShortRowOffset(index1) ) then
		return true;
	end
	return false;
end

function IsLowerRightNeighbour(index1, index2)
	if ( index1 == ( ( index2 + patternFormatInfo["max_pattern_width"] ) + 1) - IsInShortRowOffset(index1) ) then
		return true;
	end
	return false;
end

-- returns true if the bead at the specified patternIndex in the current pattern is a neighbour of the last sewn bead, false otherwise
-- Note: can assume the bead at patternIndex is a part of the pattern (i.e. ~= "none") since this should be triggered from a mouseOver event and beads not
-- part of the pattern will not be drawn and therefore will not be able to be moused over
function IsNeighbour(patternIndex)
	local lastSewn = firstBeadIndex;
	if ( numBeadsSewn > 0 ) then
		lastSewn = sewnBeadHistory[numBeadsSewn].index;
	end
	
	if ( IsLeftNeighbour( patternIndex, lastSewn ) == true ) then
		return true;
	end

	if ( IsRightNeighbour( patternIndex, lastSewn ) == true ) then
		return true;
	end

	if ( IsUpperLeftNeighbour( patternIndex, lastSewn ) == true ) then
		return true;
	end

	if ( IsUpperRightNeighbour( patternIndex, lastSewn ) == true ) then
		return true;
	end
	
	if ( IsLowerLeftNeighbour( patternIndex, lastSewn ) == true ) then
		return true;
	end

	if ( IsLowerRightNeighbour( patternIndex, lastSewn ) == true ) then
		return true;
	end
	-- not a neighbour
	return false;
end

-- returns true if the bead at the specified patternIndex in the current pattern is the same colour as the current bead to be sewn on the strand, false otherwise
function IsCorrectColour(patternIndex)
	if ( currentStrand[numBeadsSewn + 1] and currentPattern[patternIndex].colour == currentStrand[numBeadsSewn + 1].colour ) then
		return true;
	end
	return false;
end

function CanSew(patternIndex)
	if ( IsNeighbour(patternIndex) == true and IsCorrectColour(patternIndex) == true ) then
		return true;
	end
	return false;
end

function debug_show_bead()	
	local debugstring = sewnBeadHistory[1].index
	for i = 2, numBeadsSewn do
		debugstring = debugstring .. ", " .. sewnBeadHistory[i].index;
	end
	
	scene.DEBUG_OUT:SayRaw(debugstring);
end

function get_beadLite_spec( _position, _image )
	return
	{
		name = "BEADLITE";
		gfx = { image = _image };
		
		command = function(actor)
			actor:SetDepthValue( 60 );
			actor:JumpToPoint { x = _position.x, y = _position.y };
		end;
	}
end;

function beadFly( flo )
	scene:SetMode(MODE.CUTSCENE);
	local bead = scene:Spawn( get_beadLite_spec( pathNodes[1], flyInfo.sewn ) );
	bead:SetWalkSpeed( 26 );
	local xPos = GetBeadInPatternXPos(flyInfo.column, flyInfo.row);
	local yPos = GetBeadInPatternYPos(flyInfo.row);
	bead:WalkToXY( { x = xPos, y = yPos } );
	numBeadsSewn = numBeadsSewn + 1;
	currentPattern[flyInfo.index].sewn = true;
	table.insert (sewnBeadHistory, numBeadsSewn, { index = flyInfo.index, column = flyInfo.column, row = flyInfo.row });		
	sfx:PlaySFX("audio/sfx/clothing_rollover.ogg");
	
	delay(10);
	
	UpdateBeadsOnStrand();
	
	wait_walkto(bead);
	bead:Expire();			
	
	ShowLink(); -- must be called after incrementing numBeadsSewn and after table insert
	sfx:PlaySFX( "audio/sfx/bead_sew.ogg", false );
	
	if debug_show_bead_order then
		debug_show_bead();
	end	
	
	if initial_tutorial == true and going_back == false then
		if ( bead_tutorial_step == 1 ) then
			help_panel_say_raw(scene:grabstring("tutorial_text_2"));
			bead_tutorial_step =  2;
			scene.TUTORIAL_ARROW_1:SetAlpha( 0 );
			scene.TUTORIAL_CIRCLE_1:SetAlpha( 0 );
			flo:StartProc(tutorial_2);
		elseif ( bead_tutorial_step == 2 ) then
			help_panel_say_raw(scene:grabstring("tutorial_text_3"));
			bead_tutorial_step =  3;
			scene.TUTORIAL_ARROW_2:SetAlpha( 0 );
			scene.TUTORIAL_CIRCLE_2_1:SetAlpha( 0 );
			scene.TUTORIAL_CIRCLE_2_2:SetAlpha( 0 );
			initial_tutorial = false;
			spawn_button(reset_activity_button_spec);
		end
	end
				
	flyInfo.bead:LoadImage(flyInfo.sewn);
	flyInfo.bead.img_highlight = flyInfo.sewnHighlight;
	if ( numBeadsSewn == numBeadsInPattern ) then
		flyInfo.bead:LoadImage(flyInfo.sewn);
		flyInfo.bead.img_standard = flyInfo.sewn;
		scene.FLO:StartProc(activity_passed);
	end
	flyInfo = { };
	scene:SetMode(MODE.FOLLOWCLICKS);
end

function SewBead(_index, _column, _row)	
	currentPattern[_index].sewn = true;
	numBeadsSewn = numBeadsSewn + 1;
	table.insert (sewnBeadHistory, numBeadsSewn, { index = _index, column = _column, row = _row });	
	ShowLink(); -- must be called after incrementing numBeadsSewn and after table insert
	sfx:PlaySFX( "audio/sfx/bead_sew.ogg", false );
	UpdateBeadsOnStrand();
	
	if debug_show_bead_order then
		debug_show_bead();
	end
end

function SewBead2( _index, _column, _row, button, _sewnHighlight, _sewn )
	flyInfo = { index = _index, column = _column, row = _row, bead = button, sewnHighlight = _sewnHighlight, sewn = _sewn };	
	scene.FLO:StartProc( beadFly );					
end

function UnsewBead(index)
	currentPattern[index].sewn = false;					
	table.remove(sewnBeadHistory, numBeadsSewn);
	HideLink(); -- must be called before decrementing numBeadsSewn
	numBeadsSewn = numBeadsSewn - 1;
	sfx:PlaySFX( "audio/sfx/bead_remove.ogg", false );
	--UpdateBeadsOnStrand();
	ContinuousPathMove( 1, 10 );
	
	if debug_show_bead_order then
		debug_show_bead();
	end
end

-- Just snaps beads to next position on path, interchangeable with ContinuousPathMove
function UpdateBeadsOnStrand()
	for i = 1, numBeadsInPattern do
		if ( i <= numBeadsSewn ) then
			currentStrand[i].bead:SetAlpha(0);
			currentStrand[i].bead:SayRaw("");
		else			
			local xPos = pathNodes[( i - numBeadsSewn )].x;
			local yPos = pathNodes[( i - numBeadsSewn )].y;
			currentStrand[i].bead:JumpToPoint { x = xPos, y = yPos };
			currentStrand[i].bead:SetAlpha(1);			
			if ( yPos >= 0 ) then -- don't display names if offscreen, since text is always drawn on-screen regardless
				currentStrand[i].bead:SayRaw("");--currentStrand[i].bead.name);
			else
				currentStrand[i].bead:SayRaw("");
			end
		end		
	end
end

-- Moves beads to next position on path, interchangeable with UpdateBeadsOnStrand
-- This is my attempt at moving beads along a path. It is either barely noticeable over such short distances or render calls are not made by the engine during execution of this function, 
-- meaning it will visually appear the same as UpdateBeadsOnStrand
function ContinuousPathMove( curStep, numSteps )
	if ( curStep < numSteps ) then
		-- move all the beads one step
		for i = 1, numBeadsInPattern do		
			if ( i <= numBeadsSewn ) then
				currentStrand[i].bead:SetAlpha(0);
			else
				local xPos = pathNodes[( i - ( numBeadsSewn - 1 ) )].x + ( ( pathNodes[( i - numBeadsSewn )].x - pathNodes[( i - ( numBeadsSewn - 1 ) )].x ) * ( curStep / numSteps ) );
				local yPos = pathNodes[( i - ( numBeadsSewn - 1 ) )].y + ( ( pathNodes[( i - numBeadsSewn )].y - pathNodes[( i - ( numBeadsSewn - 1 ) )].y ) * ( curStep / numSteps ) );
				currentStrand[i].bead:JumpToPoint { x = xPos, y = yPos };
				currentStrand[i].bead:SetAlpha(1);
			end
		end
		-- then do the next step so it looks like all the beads are moving simultaneously
		ContinuousPathMove( curStep + 1, numSteps );
	end
end


function ShowLink()
	-- spawn link between last two sewn beads
	if ( numBeadsSewn > 1 ) then
	-- don't draw link if only one bead sewn
		local indexOfSecondLastBeadSewn = sewnBeadHistory[numBeadsSewn - 1].index;
		local indexOfLastBeadSewn = sewnBeadHistory[numBeadsSewn].index;
		local position = currentPattern[indexOfLastBeadSewn].bead:GetPosition();
		local lastBeadSewnX = position.x;
		local lastBeadSewnY = position.y;
		local position2  = currentPattern[indexOfSecondLastBeadSewn].bead:GetPosition()
		local secondLastBeadSewnX = position2.x;
		local secondLastBeadSewnY = position2.y;
		local xPosLink = ( lastBeadSewnX + secondLastBeadSewnX ) / 2;
		local yPosLink = ( lastBeadSewnY + secondLastBeadSewnY ) / 2;	

		-- select the correct link image depending on the orientation of the link
		local image = "";
		if ( IsLeftNeighbour( indexOfLastBeadSewn, indexOfSecondLastBeadSewn ) == true or IsRightNeighbour( indexOfLastBeadSewn, indexOfSecondLastBeadSewn ) == true ) then
			image = linkTypes["horizontal"].image;		
			yPosLink = yPosLink + beadFormatInfo["bead_radius"];			
		elseif ( IsLowerRightNeighbour( indexOfLastBeadSewn, indexOfSecondLastBeadSewn ) == true or IsUpperLeftNeighbour( indexOfLastBeadSewn, indexOfSecondLastBeadSewn ) == true ) then
			image = linkTypes["topLeftToBottomRight"].image;			
			xPosLink = xPosLink + beadFormatInfo["horizontal_space_between_beads"] / 4;
			yPosLink = yPosLink + beadFormatInfo["vertical_space_between_beads"] / 4;
		elseif ( IsLowerLeftNeighbour( indexOfLastBeadSewn, indexOfSecondLastBeadSewn ) == true or IsUpperRightNeighbour( indexOfLastBeadSewn, indexOfSecondLastBeadSewn ) == true ) then
			image = linkTypes["topRightToBottomLeft"].image;		
			xPosLink = xPosLink + beadFormatInfo["horizontal_space_between_beads"] / 4;
			yPosLink = yPosLink + beadFormatInfo["vertical_space_between_beads"] / 4;
		end

		local link = get_link_spec( "link" .. tostring(indexOfSecondLastBeadSewn) .. "-" .. tostring(indexOfLastBeadSewn), image, xPosLink, yPosLink);
		table.insert (links, numBeadsSewn, scene:Spawn(link));
	end		
end

function HideLink(linkIndex)
	links[numBeadsSewn]:Expire();
	table.remove(links, numBeadsSewn);
end

function get_link_spec(_name, _image, _x, _y)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		command = function(actor)
			actor:SetDepthValue(1); -- behind all the beads
			actor:JumpToPoint { x = _x, y = _y };
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 19,
				x = 5,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");--_name);
		end;
	}
end

function GetBeadInPatternXPos(column, row)
	if ( fmod( row, 2 ) == 0 ) then
		return ( patternFormatInfo["bead_horizontal_offset"] / 2 ) + patternFormatInfo["screen_x_offset"] + ( column * patternFormatInfo["bead_horizontal_offset"] );
	end
	return patternFormatInfo["screen_x_offset"] + ( column * patternFormatInfo["bead_horizontal_offset"] );
end

function GetBeadInPatternYPos(row)
	return patternFormatInfo["screen_y_offset"] + ( row * patternFormatInfo["bead_vertical_offset"] );
end

function spawn_bead_strand()
	local activityNum = game:Get("mg_bead_activity_num");
	local activityRound = game:Get("mg_bead_activity_round");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end

	for h,u in pairs(strands) do
		if h == activityRound then 
			for i,v in pairs(u) do
				if i == activityNum then 
					-- v is the strand for the current level		
					numBeadsInPattern = v.length;			
					for k = 1, v.length do -- k is the index of the bead on the strand
						local strand = v.beads;
						local xPos = strandFormatInfo["screen_x_offset"] + ( k * strandFormatInfo["bead_horizontal_offset"] );
						local yPos = strandFormatInfo["screen_y_offset"];
						-- give the beads names based on their position k
						local bead_item_spec = get_bead_strand_spec(strand[k] .. tostring(i) .. "S" .. tostring(k), strand[k], beads[strand[k]].sewn, xPos, yPos, k);
						table.insert (currentStrand, k, { colour = strand[k], bead = scene:Spawn(bead_item_spec) });
						--table.insert (currentSolution, k, v.solution[k]);
						--currentSolution = copy_table(v.solution[k]);
					end

					currentSolution = deep_copy_table(v.solution);
				end
			end
		end
	end
	UpdateBeadsOnStrand();
end

function bead_load_party(bead_strand)
	bead_strand:LoadPartyDepth("quest/shared/bead_" .. bead_strand.colour .. ".lua", 30);
	delay(40);
	bead_strand:DumpParty();
end

function get_bead_strand_spec(_name, _colour, _image, _x, _y, _k)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetDepthValue(50);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 19,
				x = 5,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:AddFlag(AFLAG.AFLAG_NEW_PARTY);
			actor:SetPartyOffset( { x = 20, y = 20 } );
			actor:SayRaw("");
			actor.colour = _colour;
		end;
	}
end

function spawn_pattern()
	local activityNum = game:Get("mg_bead_activity_num");
	local activityRound = game:Get("mg_bead_activity_round");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end

	for h,u in pairs(patterns) do
		if h == activityRound then 
			for i,v in pairs(u) do
				if i == activityNum then 
					-- v is the pattern for the current level
					firstBeadIndex = v.firstBeadIndex;
					numLoadedBeadsInPattern = v.loadedBeads;
					for j,w in pairs(v.rows) do -- j is vertical index of bead
						-- w is the row, j is the index of the row
						for k = 1, patternFormatInfo["max_pattern_width"] do -- k is the horizontal index of the bead
							local xPos = GetBeadInPatternXPos(k, j);
							local yPos = GetBeadInPatternYPos(j);
							-- give the beads names based on their position k,j
							local bead_item_spec = get_bead_spec(w[k] .. tostring(i) .. tostring(k) .. tostring(j), w[k], beads[w[k]].image, beads[w[k]].highlight, beads[w[k]].sewn, beads[w[k]].sewnHighlight, xPos, yPos, k, j);
							local index = ( (j - 1) * patternFormatInfo["max_pattern_width"] ) + k;					
							if ( index == firstBeadIndex ) then
								local spawnedBead = scene:Spawn(bead_item_spec);
								spawnedBead:LoadImage(beads[w[k]].sewn);
								spawnedBead.img_standard = beads[w[k]].sewn;
								spawnedBead.img_highlight = beads[w[k]].sewnHighlight;
								table.insert (currentPattern, index, { bead = spawnedBead, colour = w[k], sewn = false });		
								SewBead(index, k, j, true);						
							else
								table.insert (currentPattern, index, { bead = scene:Spawn(bead_item_spec), colour = w[k], sewn = false });								
							end								
						end				
					end
				end
			end
		end
	end
end

function clear_pattern_meshes()
	for i,v in pairs(currentPattern) do
		v.bead:DumpZone();
	end
end

function get_bead_spec(_name, _colour, _image, _highlight, _sewn,  _sewnHighlight, _x, _y, _k, _j)
	return
	{
		name = "~" .. _name;
		halo = "bead";
		gfx = { image = _image };
		
		command = function(actor)
			actor:SetDepthValue( 40 );
			actor:SetPointAtCursor("cursor");
			actor:JumpToPoint { x = _x, y = _y };
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw(""); --_name);
			--if _image ~= "" then
			--	actor:AddFlag(AFLAG.AFLAG_NEW_PARTY);
			--	actor:LoadPartyDepth("quest/shared/bead_green.lua", 30);
			--	actor:SetPartyOffset( { x = -5, y = -9 } );
			--end
			
			actor.k = _k;
			actor.j = _j;
			actor.img_standard = _image;
			actor.img_highlight = _highlight;
			actor.img_sewn = _sewn;
			actor.img_sewnHighlight = _sewnHighlight;
			
			actor:AddFlag(AFLAG.AFLAG_NEW_PARTY);
			--actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
			actor:SetPartyOffset( { x = 20, y = 20 } );
			actor.colour = _colour;
		end;
		
		on_click = function(flo, button)
			if ( activityComplete == true ) then
				sfx:PlaySFX("audio/sfx/clicksound_ground_invalid.ogg");
				return RESPONSE_IGNORE;
			end
			
			if ( bead_tutorial_step == 2 and ( ( _k ~= 3 ) or ( _j ~= 5 )  ) ) then
				sfx:PlaySFX("audio/sfx/clicksound_ground_invalid.ogg");
				return RESPONSE_IGNORE;
			end
			
			if scene:GetMode() == MODE.CUTSCENE then
				sfx:PlaySFX("audio/sfx/clicksound_ground_invalid.ogg");
				return RESPONSE.IGNORE;
			end
			
			beadFlashing = false;
			local index = ( (_j - 1) * patternFormatInfo["max_pattern_width"] ) + _k;
			if ( currentPattern[index].sewn == false and CanSew(index)  == true )  then
				SewBead2(index, _k, _j, button, _sewnHighlight, _sewn);
			else
				-- local lastSewn = sewnBeadHistory[numBeadsSewn].index;				
				if ( index == sewnBeadHistory[numBeadsSewn].index  and index ~= firstBeadIndex ) then
				-- if bead is the last sewn bead and bead is not the first sewn bead (must be at least one bead sewn at all times)
					UnsewBead(index);
					if ( CanSew(index) == true ) then
						button:LoadImage(_highlight);
						button.img_highlight = _highlight;
					else
						button:LoadImage(_image);
						button.img_standard = _image;
					end
				else
					sfx:PlaySFX("audio/sfx/clicksound_ground_invalid.ogg");
				end
			end
			return RESPONSE.IGNORE;
		end;
		
		point_at_fn = function(actor, enter)
			if scene:GetMode() ~= MODE.CUTSCENE then
				if ( activityComplete == true ) then
					return RESPONSE_IGNORE;
				end
				local index = ( (_j - 1) * patternFormatInfo["max_pattern_width"] ) + _k;
				if ( currentPattern[index].sewn == false and CanSew(index)  == true )  then
					if enter then
						actor:LoadImage(_highlight);
						actor.img_highlight = _highlight;
						actor:SetPointAtCursor("cursor_glow");
						sfx:PlaySFX("audio/sfx/bead_rollover.ogg");
					else
						actor:LoadImage(_image );
						actor.img_standard = _image;
						actor:SetPointAtCursor("cursor");
					end;
				elseif ( index == sewnBeadHistory[numBeadsSewn].index  and index ~= firstBeadIndex ) then
					if enter then
						actor:LoadImage(_sewnHighlight);
						actor.img_highlight = _sewnHighlight;
						actor:SetPointAtCursor("cursor_glow");
						sfx:PlaySFX("audio/sfx/bead_rollover.ogg");
					else
						actor:LoadImage(_sewn);
						actor.img_standard = _sewn;
						actor:SetPointAtCursor("cursor");
					end;
				end
			elseif transitioning == false then
				local index = ( (_j - 1) * patternFormatInfo["max_pattern_width"] ) + _k;
				if ( currentPattern[index].sewn == false and CanSew(index)  == true )  then
					if enter then
						actor:SetPointAtCursor("cursor_glow");
						sfx:PlaySFX("audio/sfx/bead_rollover.ogg");
					else
						actor:SetPointAtCursor("cursor");
					end;
				elseif ( index == sewnBeadHistory[numBeadsSewn].index  and index ~= firstBeadIndex ) then
					if enter then
						actor:SetPointAtCursor("cursor_glow");
						sfx:PlaySFX("audio/sfx/bead_rollover.ogg");
					else
						actor:SetPointAtCursor("cursor");
					end;
				end
			end
		end;
	}
end

function setup_activity()
	local activityNum = game:Get("mg_bead_activity_num");
	local activityRound = game:Get("mg_bead_activity_round");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(activity_title_spec);
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
		end
		sfx:PlaySFX("audio/sfx/fabric_transition.ogg")
		initial_setup = false;
		coroutine.yield(RESUME.NOW);		
	else
	end

	if not activityMode then
		if activityNum == 1 and activityRound == 1 then
			bead_tutorial_step = 1;					
			initial_tutorial = true;
		else
			help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		end
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	reset();
	delay(5);
	spawn_pattern();
	sfx:PlaySFX( "audio/sfx/new_pattern.ogg", false );
	DoTransitionOn();
	
	if not initial_tutorial then
		spawn_button(reset_activity_button_spec);
	end
	
	if not activityMode and going_back == false then
		spawn_button(hint_button_spec);
		move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
	end
	
	spawn_bead_strand();
	activityComplete = false;
end;

function DoTransitionOn()
	scene:SetMode(MODE.CUTSCENE);
	scene.ROLLER_RIGHT:PlayAnim("RollerRight");
	scene.ROLLER_LEFT:PlayAnim("RollerLeft");
	transitioning = true;
	local j = 0;
	local speed = 5;
	while ( j < 400 ) do
		for i = 1, numLoadedBeadsInPattern do 	
			local xPos = GetBeadInPatternXPos(currentPattern[i].bead.k, currentPattern[i].bead.j);
			local yPos = GetBeadInPatternYPos(currentPattern[i].bead.j);
			currentPattern[i].bead:JumpToPoint( { x = xPos - ( 400 - j ), y = yPos } );			
		end
		j = j + speed;		
		delay(1);
	end	
	scene.ROLLER_RIGHT:PlayAnim("RollerRightStop");
	scene.ROLLER_LEFT:PlayAnim("RollerLeftStop");
	scene:SetMode(MODE.FOLLOWCLICKS);
	if ( bead_tutorial_step == 1 and going_back == false ) then
		help_panel_say_raw(scene:grabstring("tutorial_text_1"));	
		scene.TUTORIAL_ARROW_1:SetAlpha( 1 );
		scene.FLO:StartProc(tutorial_1);
	end
	transitioning = false;
end

function tutorial_1(flo)
	for i = 1, 5 do
		scene.TUTORIAL_CIRCLE_1:SetAlpha( 0 );
		delay(15);
		scene.TUTORIAL_CIRCLE_1:SetAlpha( 1 );
		delay(15);
	end
end

function tutorial_2(flo)
	for i = 1, 3 do
		scene.TUTORIAL_CIRCLE_2_1:SetAlpha( 1 );
		delay(15);
		scene.TUTORIAL_CIRCLE_2_1:SetAlpha( 0 );
		scene.TUTORIAL_CIRCLE_2_2:SetAlpha( 1 );
		delay(15);
		scene.TUTORIAL_CIRCLE_2_2:SetAlpha( 0 );
	end
	scene.TUTORIAL_CIRCLE_2_2:SetAlpha( 1 );
	scene.TUTORIAL_ARROW_2:SetAlpha( 1 );
	
end

function DoTransitionOff()
	scene.ROLLER_RIGHT:PlayAnim("RollerRight");
	scene.ROLLER_LEFT:PlayAnim("RollerLeft");
	local j = 0;
	local speed = 5;
	while ( j < 100 ) do
		for i = 1, numLoadedBeadsInPattern do 	
			local pos = currentPattern[i].bead:GetPosition();
			currentPattern[i].bead:JumpToPoint( { x = pos.x + speed, y = pos.y } );			
		end
		for k = 2, numBeadsSewn do
			local pos = links[k]:GetPosition();
			links[k]:JumpToPoint( { x = pos.x + speed, y = pos.y } );
		end
		j = j + 1;		
		delay(1);
	end
	scene.ROLLER_RIGHT:PlayAnim("RollerRightStop");
	scene.ROLLER_LEFT:PlayAnim("RollerLeftStop");
end

function next_activity(flo)
	local activityNum = game:Get("mg_bead_activity_num");
	local activityRound = game:Get("mg_bead_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	local activityMode = game:Get("activity_mode") == 1;
	
	sfx:PlaySFX("audio/sfx/fabric_transition.ogg")
	
	if not activityMode then
		scene.NEXT_ACTIVITY_BUTTON:Expire();
	end
	
	DoTransitionOff();
	
	if not activityMode and roundComplete then
		game:Set("beadmachine_has_beads", 0); -- out of beads!
		goto_scene(flo, "m1_dress");	
	else
		if IsCheatMode() then
			if not activityMode then
				spawn_button(pass_activity_button_spec);
			end
		end
		
		if activityMode then
			spawn_button(start_button_spec);
			move_actor_y(scene.START_BUTTON, -hud_lower_offset);
		end
		
		spawn_button(back_button_spec);
		move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		
		if not activityMode then
			-- load new puzzle		
			setup_activity();
		else
			kill_activity_timer();
		end
	end
end;

function reset_activity(flo)
	if scene.BEADLITE then
		ShowLink();
		scene.BEADLITE:Expire();
		scene:SetMode(MODE.FOLLOWCLICKS);
	end
	reset();
	delay(2);
	spawn_pattern();
	--DoTransitionOn();
	
	spawn_bead_strand();
end

function activity_passed(flo)
	local activityNum = game:Get("mg_bead_activity_num");
	local activityRound = game:Get("mg_bead_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	local activityMode = game:Get("activity_mode") == 1;

	clear_pattern_meshes();
	
	if not activityMode and scene.HINT_BUTTON then
		scene.HINT_BUTTON:Expire();
	end
	
	activityComplete = true;
	stop_activity_timer(); -- quest/activity_mode/activity_timer.lua
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
	end
	
	scene.BACK_BUTTON:Expire();
	scene.RESET_ACTIVITY_BUTTON:Expire();
	
	if not activityMode then
		spawn_button(next_activity_button_spec);
		scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
		
		if roundComplete then			
			help_panel_say_raw(scene:grabstring("round_complete_" .. tostring(activityRound)));		
			if activityRound == 1 then
				game:Set("mg_bead_activity_round", 2);
				game:Set("mg_bead_activity_num", 1);
			else -- round == 2
				-- Scene Finished			
				game:Set("mg_bead_activity_round", 3);
				game:Set("mg_bead_activity_num", 1);
				--goto_scene(flo, "m1_dress");	
			end
		else
			help_panel_say_raw(scene:grabstring("activity_complete_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
			game:Set("mg_bead_activity_num", activityNum + 1);
		end
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_pattern.ogg");
	play_end_particles();
	
	if scene.ACTIVITY_COMPLETE then
		coroutine.yield(RESUME.ON_SIGNAL);
	end
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
		roundComplete = activityNum == round_num[activityRound];
		
		--if roundComplete then
		--	game:EarnAward("avenue-flo_beadingmaster");
		--end
	
		show_activity_results();
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		actor:ModifySaySpec(flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;

	on_click = function(actor, flo)
		help_panel_say_raw(scene:grabstring("instructions"));
		return RESPONSE.IGNORE;
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	going_back = true;
	kill_help_panel();
	goto_scene(flo, "m1_dress");
end

random_particles_spec = 
{
	name = "RANDOM_PARTICLES";
	
	command = function(actor)
		while true do
			delay(300);
			for i = 1, numBeadsInPattern do
				if ( i > numBeadsSewn and currentStrand[i]) then
					currentStrand[i].bead:StartProc(bead_load_party);
					delay(3);
				end
			end
			
			for i = 1, numLoadedBeadsInPattern do 	
				if currentPattern[i] and currentPattern[i].sewn == true then
					if math.random(1, 4) == 3 then
						currentPattern[i].bead:StartProc(bead_load_party);
						delay(10);
					end
				end
			end
		end
	end;
}

function play_end_particles()
	local particle_line = 0;
	local particle_line_speed = 10;
	local max_particle_line = 800;
	
	while particle_line < max_particle_line do
		local particle_line_begin = particle_line;
		particle_line = particle_line + particle_line_speed;
		
		for i = 1, numLoadedBeadsInPattern do 	
			if currentPattern[i].sewn == true then
				local bead_position = currentPattern[i].bead:GetPosition();
				
				if bead_position.x > particle_line_begin and bead_position.x < particle_line then
					currentPattern[i].bead:StartProc(bead_load_party);
				end
			end
		end
		delay(1);
	end
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/dressshopmusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		delay(1); -- so any variables can be set properly (i.e. activity_mode)
		local activityMode = game:Get("activity_mode") == 1;
		game:ClearInvUsage();
		
		fade_scene_up(true);
		lower_hud();
		if activityMode then
			spawn_button(start_button_spec);
		end
		spawn_help_panel();
		
		if IsCheatMode() then
			if not activityMode then
				spawn_button(pass_activity_button_spec);
			end
		end
		
		-- set up for initial play
		if game:Get("mg_bead_activity_num") < 1 then
			game:Set("mg_bead_activity_num", 1);
		end
		
		if game:Get("mg_bead_activity_round") < 1 then
			game:Set("mg_bead_activity_round", 1);
		end
		
		scene:Spawn(random_particles_spec);
		
		-- unlock beading in activity mode
		if game:Get("beading_unlocked") < 1 then
			game:Set("beading_unlocked", 1);
			game:Set("activity_unlocked", 1);
		end
		
		scene:Spawn{name = "BEAD_FLASHER"}; -- for bead hint
		
		if not activityMode then
			setup_activity();
		else
			help_panel_activity_mode_intro();
		end
	end;
};

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		MET_Count("HintsClicked");
		local allRightSoFar = true;
		local j = 0;
		local k = 0;
		local bestSolution = 0;
		while k < table.getn(currentSolution) do
			k = k + 1;
			allRightSoFar = true
			for i = 1, numBeadsSewn do
				if ( sewnBeadHistory[i].index ~= currentSolution[k][i] ) then
					allRightSoFar = false;
					break;
				end
				
				if i > j then
					j = i;
					bestSolution = k;
				end
			end
			
			if allRightSoFar then
				break;
			end
		end
		if ( allRightSoFar == true ) then
			help_panel_say_raw( scene:grabstring("hint_perfect") );
			hintPerfect = true;
			FlashBead(k,j+1,j+1);
		else
			help_panel_say_raw( scene:grabstring("hint_wrong") );
			hintPerfect = false;
			FlashBead(bestSolution,1,j);
		end		
	end;
}

function FlashBead( solution, start, count )
	local bead_flasher = scene.BEAD_FLASHER;
	
	scene.BEAD_FLASHER:StartProc(function(actor)
		spawn_cancel_hint_on_click(solution, start, count);
		scene.HINT_BUTTON:SetAlpha( 0 );
		scene.HINT_BUTTON:SayRaw( "" );
		scene.HINT_BUTTON:ModifySaySpec
		{
			lineheight = 0,
		};
		scene.HINT_BUTTON:DumpZone();
		
		if scene.RESET_ACTIVITY_BUTTON then
			scene.RESET_ACTIVITY_BUTTON:SetAlpha( 0 );
			scene.RESET_ACTIVITY_BUTTON:SayRaw( "" );
			scene.RESET_ACTIVITY_BUTTON:ModifySaySpec
			{
				lineheight = 0,
			};
			scene.RESET_ACTIVITY_BUTTON:DumpZone();
		end
		
		beadFlashing = true;
		
		for i = 1, 3 do
			for i = start, count do
				local bead = currentPattern[currentSolution[solution][i]].bead;
				if ( hintPerfect ) then
					bead:LoadImage(bead.img_highlight);--SetScale( 1.2 );
				else
					bead:LoadImage(bead.img_sewnHighlight);--SetScale( 1.2 );
				end
				if ( beadFlashing == false ) then
					break;
				end
			end
			delay(15);		
			
			for i = start, count do
				local bead = currentPattern[currentSolution[solution][i]].bead;
				if ( hintPerfect ) then
					bead:LoadImage(bead.img_standard);--SetScale( 1 );
				else
					bead:LoadImage(bead.img_sewn);--SetScale( 1 );
				end
				if ( beadFlashing == false ) then
					break;
				end
			end
			delay(15);
		end
		safe_kill_actor(scene.CANCEL_HINT_ON_CLICK);
		finish_hint(solution, start, count);
	end);
end

function finish_hint(solution, start, count)
	scene.BEAD_FLASHER:StartProc(function(actor)
		for i = start, count do
			local bead = currentPattern[currentSolution[solution][i]].bead;
			if ( hintPerfect ) then
				bead:LoadImage(bead.img_standard);--SetScale( 1 );
			else
				bead:LoadImage(bead.img_sewn);--SetScale( 1 );
			end
		end
		
		if scene.HINT_BUTTON then
			scene.HINT_BUTTON:SetAlpha( 1 );
			scene.HINT_BUTTON:ModifySaySpec
			{
				lineheight = 17,
			};
			scene.HINT_BUTTON:SayRaw( scene:grabstring( "hint" ) );
			scene.HINT_BUTTON:LoadZone("quest/objects/button_thin");
		end
		
		if scene.RESET_ACTIVITY_BUTTON then
			scene.RESET_ACTIVITY_BUTTON:SetAlpha( 1 );
			scene.RESET_ACTIVITY_BUTTON:ModifySaySpec
			{
				lineheight = 17,
			};
			scene.RESET_ACTIVITY_BUTTON:SayRaw( scene:grabstring( "reset" ) );
			scene.RESET_ACTIVITY_BUTTON:LoadZone("quest/objects/button_thin");
		end
		
		beadFlashing = false;
	end);
end;

function spawn_cancel_hint_on_click(solution, start, count)
	if  scene.CANCEL_HINT_ON_CLICK == nil then
		scene:Spawn
		{
			name = "CANCEL_HINT_ON_CLICK";
			
			command = function(actor)
				coroutine.yield(RESUME.ON_CLICK);
				finish_hint(solution, start, count);
				actor:Expire();
			end;
		};
	end
end

tutorial_arrow_1_spec =
{
	name = "TUTORIAL_ARROW_1";
	gfx = { image = "arrow_1" };
	
	command = function(actor)
		actor:SetDepthValue( 200 );
		actor:SetAlpha( 0 );
	end;
}

tutorial_arrow_2_spec =
{
	name = "TUTORIAL_ARROW_2";
	gfx = { image = "arrow_2" };
	
	command = function(actor)
		actor:SetDepthValue( 200 );
		actor:SetAlpha( 0 );
	end;
}

tutorial_circle_1_spec =
{
	name = "TUTORIAL_CIRCLE_1";
	gfx = { image = "circle_1" };
	
	command = function(actor)
		actor:SetDepthValue( 200 );
		actor:SetAlpha( 0 );
	end;
}

tutorial_circle_2_1_spec =
{
	name = "TUTORIAL_CIRCLE_2_1";
	gfx = { image = "circle_2_1" };
	
	command = function(actor)
		actor:SetDepthValue( 200 );
		actor:SetAlpha( 0 );
	end;
}

tutorial_circle_2_2_spec =
{
	name = "TUTORIAL_CIRCLE_2_2";
	gfx = { image = "circle_2_2" };
	
	command = function(actor)
		actor:SetDepthValue( 200 );
		actor:SetAlpha( 0 );
	end;
}

roller_left_spec = 
{
	name = "ROLLER_LEFT";
	gfx = { anim = "anim/mg_bead/rollers" };
	
	command = function(actor)
		actor:SetDepthValue(1);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("RollerLeftStop");
	end
}

roller_right_spec = 
{
	name = "ROLLER_RIGHT";
	gfx = { anim = "anim/mg_bead/rollers" };
	
	command = function(actor)
		actor:SetDepthValue(1);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("RollerRightStop");
		
		actor:SetScaleX(-1);
		actor:JumpToPoint{ x = 820, y = 0 };
	end
}

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "bead_tube_mask", 100 },
		
		{ "beadmachine_left", 50 },
		{ "beadmachine_right", 50 },
		{ "beadmachine_lefttop", 90 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		tutorial_arrow_1_spec,
		tutorial_arrow_2_spec,
		tutorial_circle_1_spec,
		tutorial_circle_2_1_spec,
		tutorial_circle_2_2_spec,
		scene_setup,
		roller_left_spec,
		roller_right_spec,
	};
};
